/*******************************************************************************
 Module for Microchip Legato Graphics Library

  Company:
    Microchip Technology Inc.

  File Name:
    le_gen_assets.h

  Summary:
    Header file containing a list of asset specifications for use with the
    Legato Graphics Stack.


  Description:
    Header file containing a list of asset specifications for use with the
    Legato Graphics Stack.

*******************************************************************************/


// DOM-IGNORE-BEGIN
/*******************************************************************************
* Copyright (C)  Microchip Technology Inc. and its subsidiaries.
*
* Subject to your compliance with these terms, you may use Microchip software
* and any derivatives exclusively with Microchip products. It is your
* responsibility to comply with third party license terms applicable to your
* use of third party software (including open source software) that may
* accompany Microchip software.
*
* THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
* EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED
* WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
* PARTICULAR PURPOSE.
*
* IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE,
* INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND
* WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS
* BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO THE
* FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN
* ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY,
* THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
*******************************************************************************/

// DOM-IGNORE-END

#ifndef LE_GEN_ASSETS_H
#define LE_GEN_ASSETS_H

// DOM-IGNORE-BEGIN
#ifdef __cplusplus  // Provide C++ Compatibility
extern "C" {
#endif
// DOM-IGNORE-END

#include "gfx/legato/legato.h"

extern const lePalette leGlobalPalette;

/*****************************************************************************
 * Legato Graphics Image Assets
 *****************************************************************************/
/*********************************
 * Legato Image Asset
 * Name:   bulb_off
 * Size:   120x44 pixels
 * Type:   RGB Data
 * Format: RGB_565
 ***********************************/
extern leImage bulb_off;

/*********************************
 * Legato Image Asset
 * Name:   bulb_on
 * Size:   120x44 pixels
 * Type:   RGB Data
 * Format: RGB_565
 ***********************************/
extern leImage bulb_on;

/*********************************
 * Legato Image Asset
 * Name:   Fuji240x144noJP_RGB
 * Size:   240x144 pixels
 * Type:   RGB Data
 * Format: RGB_565
 ***********************************/
extern leImage Fuji240x144noJP_RGB;

/*********************************
 * Legato Image Asset
 * Name:   GojyuKouyou_240x144_RGB
 * Size:   240x144 pixels
 * Type:   RGB Data
 * Format: RGB_565
 ***********************************/
extern leImage GojyuKouyou_240x144_RGB;

/*********************************
 * Legato Image Asset
 * Name:   SummerSea240x144_RGB
 * Size:   240x144 pixels
 * Type:   RGB Data
 * Format: RGB_565
 ***********************************/
extern leImage SummerSea240x144_RGB;

/*********************************
 * Legato Image Asset
 * Name:   Kikansha_Yuki240x144_RGB
 * Size:   240x144 pixels
 * Type:   RGB Data
 * Format: RGB_565
 ***********************************/
extern leImage Kikansha_Yuki240x144_RGB;

/*****************************************************************************
 * Legato Graphics Font Assets
 *****************************************************************************/
/*********************************
 * Legato Font Asset
 * Name:         Bold_32
 * Height:       21
 * Baseline:     25
 * Style:        Plain
 * Glyph Count:  95
 * Range Count:  1
 * Glyph Ranges: 0x20-0x7E
***********************************/
extern leRasterFont Bold_32;

/*********************************
 * Legato Font Asset
 * Name:         Bold_28
 * Height:       21
 * Baseline:     22
 * Style:        Plain
 * Glyph Count:  95
 * Range Count:  1
 * Glyph Ranges: 0x20-0x7E
***********************************/
extern leRasterFont Bold_28;

/*********************************
 * Legato Font Asset
 * Name:         Std_28
 * Height:       37
 * Baseline:     21
 * Style:        Antialias
 * Glyph Count:  95
 * Range Count:  16
 * Glyph Ranges: 0x20-0x7E
***********************************/
extern leRasterFont Std_28;

/*********************************
 * Legato Font Asset
 * Name:         Bold_24
 * Height:       21
 * Baseline:     18
 * Style:        Plain
 * Glyph Count:  95
 * Range Count:  14
 * Glyph Ranges: 0x20-0x7E
***********************************/
extern leRasterFont Bold_24;

/*********************************
 * Legato Font Asset
 * Name:         Bold_36
 * Height:       21
 * Baseline:     28
 * Style:        Plain
 * Glyph Count:  95
 * Range Count:  23
 * Glyph Ranges: 0x20-0x7E
***********************************/
extern leRasterFont Bold_36;

/*****************************************************************************
 * Legato String Table
 * Encoding        ASCII
 * Language Count: 1
 * String Count:   11
 *****************************************************************************/

// language IDs
#define language_Default    0

// string IDs
#define stringID_LED_Touch_Control    0
#define stringID_TouchAnywhere    1
#define stringID_On_Off    2
#define stringID_PIC32MZ_Evaluation_Board    3
#define stringID_INT070_inchi7_0_800x480pixel    4
#define stringID_Touch_LCD_INT070    5
#define stringID_by_Legato    6
#define stringID_NEXT    7
#define stringID_Welcome_to    8
#define stringID_Harmony_Ver3    9
#define stringID_BACK    10

extern const leStringTable stringTable;


// string list
extern leTableString string_LED_Touch_Control;
extern leTableString string_TouchAnywhere;
extern leTableString string_On_Off;
extern leTableString string_PIC32MZ_Evaluation_Board;
extern leTableString string_INT070_inchi7_0_800x480pixel;
extern leTableString string_Touch_LCD_INT070;
extern leTableString string_by_Legato;
extern leTableString string_NEXT;
extern leTableString string_Welcome_to;
extern leTableString string_Harmony_Ver3;
extern leTableString string_BACK;

void initializeStrings(void);
//DOM-IGNORE-BEGIN
#ifdef __cplusplus
}
#endif
//DOM-IGNORE-END

#endif /* LE_GEN_ASSETS_H */
